class RiderServiceState {
  final List<double> pickupLocation;
  final List<double> dropLocation;
  final List<double> waitLocation;
  final List<num?> serviceOptionIds;
  final String? pickupAddress;
  final String? dropAddress;
  final String? waitAddress;
  final String? couponCode;

  RiderServiceState({
    required this.pickupLocation,
    required this.dropLocation,
    required this.waitLocation,
    required this.serviceOptionIds,
    this.pickupAddress,
    this.dropAddress,
    this.waitAddress,
    this.couponCode,
  });

  RiderServiceState copyWith({
    List<double>? pickupLocation,
    List<double>? dropLocation,
    List<double>? waitLocation,
    List<num?>? serviceOptionIds,
    String? pickupAddress,
    String? dropAddress,
    String? waitAddress,
    String? couponCode,
  }) => RiderServiceState(
      pickupLocation: pickupLocation ?? this.pickupLocation,
      dropLocation: dropLocation ?? this.dropLocation,
      waitLocation: waitLocation ?? this.waitLocation,
      serviceOptionIds: serviceOptionIds ?? this.serviceOptionIds,
      pickupAddress: pickupAddress ?? this.pickupAddress,
      dropAddress: dropAddress ?? this.dropAddress,
      waitAddress: waitAddress ?? this.waitAddress,
      couponCode: couponCode ?? this.couponCode,
    );

  Map<String, dynamic> toMap() => {
      'pickup_location[]': pickupLocation,
      'drop_location[]': dropLocation,
      'wait_location[]': waitLocation,
      'service_option_ids[]': serviceOptionIds,
      'coupon_code': couponCode,
    };
}
